#*************************************************************************
# FILE NAME: init.s                       COPYRIGHT (c) Freescale 2008    
#                                                All Rights Reserved      
#
# This is the standard PPC init code. 
#*************************************************************************
 
  .globl __start
  
  .section .rcw, axv
   .vle
  .long 0x015a0000
  .long __start

  
  .section .init,axv     		# The "ax" generates symbols for debug
  .vle

__start:

#******************
# Enable SPE in MSR
#******************
  mfMSR r6
  e_or2is  r6, 0x0200
  mtMSR r6

#***************
# Clear Timebase
#***************
  e_li r3, 0
  mtspr 284, r3
  mtspr 285, r3

#****************
# Enable Timebase
#****************
  e_li r3, 0x4000
  mtspr HID0, r3


#***********************
# Configure MMU SRAM
#***********************
#TLB2 =  1MB for Internal RAM
   e_lis r3, 0x1003
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0500
   mtmas1 r3
   e_lis  r3, 0x4000
   e_or2i   r3, 0x0020
   mtmas2 r3
   e_lis  r3, 0x4000
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe


#***********************
# Initialize ECC in SRAM
# 596K of RAM
#***********************
  e_li   r5, 2048
  mtctr r5
  e_lis   r5,0x4000
sram_loop:
  e_stmw  r0, 0x0 (r5)
  e_addi  r5, r5, 128
  e_bdnz  sram_loop

#********************************
# Enable the branch target buffer
#********************************
  e_li	r0, 0x201
  mtspr	1013, r0

#******************
# configure the MMU
#******************
#TLB0 = pbridgeB (configured by BAM)

#TLB1 =  1M Internal flash - z6
# Execute from RAM

e_b copy_to_ram

tlb1_config:
   e_lis r3, 0x1001
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i r3, 0x0500
   mtmas1	r3

   e_lis  r3, 0x0000
   e_or2i r3, 0x0020
   mtmas2	 r3

   e_lis  r3, 0x0000
   e_or2i r3, 0x003F
   mtmas3	 r3
   tlbwe
   se_blr
   
copy_to_ram:
  e_lis r3, tlb1_config@h
  e_or2i r3, tlb1_config@l
  e_lis r4, copy_to_ram@h
  e_or2i r4, copy_to_ram@l
  subf r4, r3, r4
  mtctr r4
  e_lis r5, 0x4000
  mtlr r5

copy:
  e_lbz r6, 0(r3)
  e_stb r6, 0(r5)
  e_addi r3, r3, 1
  e_addi r5, r5, 1
  e_bdnz copy

  se_blrl

#TLB2 =  1M Internal flash - z0
   e_lis r3, 0x1002
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0500
   mtmas1 r3
   e_lis  r3, 0x0010
   e_or2i   r3, 0x0020
   mtmas2 r3
   e_lis  r3, 0x0010
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe

#TLB4 =  pbridgeA
   e_lis r3, 0x1004
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0800
   mtmas1 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x000A
   mtmas2 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe

#****************************
# Call start code (_start)
#****************************
  e_bl _start

loop_forever:
  e_b loop_forever




